<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormChangePassword()
  ===================================================*/

  function ShowFormChangePassword() {

    // vars global configuration
    global $theme_path;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    DisplayTemplate($theme_path . "cp/change_pwd_form.html", "\$error_msg");
  }


  /*===================================================
    ProcessFormChangePassword()
  ===================================================*/
  
  function ProcessFormChangePassword() {

    // vars global configuration
    global $theme_path;

    // vars url & form
    global $present_pwd, $new_pwd, $new_pwd2;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;


    // verify input

    if (empty($present_pwd))
      $error_msg = $msg["20031"];
    elseif (empty($new_pwd))
      $error_msg = $msg["20032"];
    elseif (empty($new_pwd2))
      $error_msg = $msg["20033"];
    elseif ($new_pwd2 != $new_pwd)
      $error_msg = $msg["20034"];

    if (empty($error_msg)) {
      $users_obj = new clsUsers;
      $users_obj->table_name = "idx_users";
      $auth = new auth();
      $change_result = $users_obj->ChangePassword($_COOKIE['COOKIE_USERNAME'], $auth->Convert($present_pwd), $auth->Convert($new_pwd));

      if ($change_result == 0) {
        $back_url = urlencode("cp/change_pwd.php?pflag=ok");
        Redirect("../login.php?f=1&b=$back_url&u=$_COOKIE[COOKIE_USERNAME]&p=$new_pwd&pflag=login");
      }
      else {
        $error_msg = $msg["20035"];
        ShowFormChangePassword();
      }
    }
    else {
      ShowFormChangePassword();
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormChangePassword();
  }
  elseif ($pflag == 'change') {
    ProcessFormChangePassword();
  }
  elseif ($pflag == 'ok') {
    DisplayTemplate($theme_path . "cp/change_pwd_ok.html");
  }

  RunPostFilter(__FILE__);

?>